package cn.tuia.mango.thirdparty.duiba.support;

import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.CreditConsumeResult;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.CreditTool;
import cn.tuia.mango.thirdparty.duiba.DuibaCoreService;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 兑吧必须功能接口默认实现
 * @author lijicong
 * @since 2020-04-11
 */
@Slf4j
public class DefaultDuibaCoreServiceImpl implements DuibaCoreService {

    public static final String AUTO_LOGIN_URL = "https://activity.m.duiba.com.cn/autoLogin/autologin?";

    @Override
    public String buildUrlWithSign(String appKey, String appSecret, String uid, String credits) {
        CreditTool tool = new CreditTool(appKey, appSecret);
        Map<String, String> params = new HashMap<>();
        params.put("uid", uid);
        params.put("credits", credits);
        String url = tool.buildUrlWithSign(AUTO_LOGIN_URL, params);
        return url;
    }

    @Override
    public String consume(String appKey, String appSecret, HttpServletRequest request, ConsumeCallback callback) {
        CreditTool tool = new CreditTool(appKey, appSecret);

        CreditConsumeResult result = null;
        try {
            CreditConsumeParams params = tool.parseCreditConsume(request);
            if (log.isDebugEnabled()) {
                log.debug("兑吧-扣积分接口 request={}", JSON.toJSONString(params));
            }
            result = callback.doConsume(params);
        } catch (Exception e) {
            result = new CreditConsumeResult(false);
            result.setErrorMessage(e.getMessage());
        }
        return JSON.toJSONString(request);
        //return result.toString(); // 返回扣积分结果json信息
    }

    @Override
    public String notifyResult(String appKey, String appSecret, HttpServletRequest request, NotifyCallback callback) {
        /*
         * 兑换订单的结果通知请求的解析方法
         * 当兑换订单成功时，兑吧会发送请求通知开发者，兑换订单的结果为成功或者失败，如果为失败，开发者需要将积分返还给用户
         */
        CreditTool tool = new CreditTool(appKey, appSecret);
        try {
            CreditNotifyParams params = tool.parseCreditNotify(request);//利用tool来解析这个请求
            if (log.isDebugEnabled()) {
                log.debug("兑吧-兑换结果通知接口 request={}", JSON.toJSONString(params));
            }
            String orderNum = params.getOrderNum();
            if (params.isSuccess()) {
                // 兑换成功
                callback.onSuccess(orderNum);
            } else {
                // 兑换失败，根据orderNum，对用户的金币进行返还，回滚操作
                callback.onFailure(orderNum, params.getErrorMessage());
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.warn("兑吧-兑换结果通知接口 异常 e={}", e.getMessage());
        }
        return "ok";
    }
}
