package cn.tuia.mango.thirdparty.duiba.api.model;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2020-04-14
 */
@Setter
@Getter
public class UserInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 用户唯一性标识，对应唯一一个用户且不可变 （用not_login作为uid标记游客用户，详见 游客访问） */
    private String uid;
    /** 用户积分余额（无积分体系独立活动，积分可以传0） */
    private Long credits;
    /** 登录成功后的重定向地址（需要进行urlencode编码），可以直达积分商城内的任意页面,如果不带redirect参数，默认跳转到积分商城首页 */
    private String redirect;
    /** 自定义参数 */
    private String dcustom;
    /** 自定义参数 */
    private String transfer;
    /** 自定义参数 */
    private String singKeys;
}
