package cn.tuia.mango.thirdparty.duiba;

import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeParams;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeResult;

import javax.servlet.http.HttpServletRequest;

/**
 * 兑吧必选功能接口
 * @author lijicong
 * @since 2020-04-11
 */
public interface DuibaCoreService {

    /**
     * 免密登录
     * @param appKey
     * @param appSecret
     * @param uid 用户唯一性标识
     * @param credits 用户积分余额
     * @return
     * @see <a href="http://docs.duiba.com.cn/tech_doc_book/server/general_autologin_url.html">免登录地址接口</a>
     */
    String buildUrlWithSign(String appKey, String appSecret, String uid, String credits);


    /**
     * 扣积分
     * @param appKey
     * @param appSecret
     * @param request
     * @return
     * @see <a href="http://docs.duiba.com.cn/tech_doc_book/server/consume_credits_api.html">扣积分接口</a>
     */
    CreditConsumeResult consume(String appKey, String appSecret, HttpServletRequest request, ConsumeCallback callback);

    /**
     * 兑换结果通知
     * @param appKey
     * @param appSecret
     * @param request
     * @param callback
     * @return
     * @see <a href="http://docs.duiba.com.cn/tech_doc_book/server/notify_api.html">兑换结果通知接口</a>
     */
    String notifyResult(String appKey, String appSecret, HttpServletRequest request, NotifyCallback callback);


    interface ConsumeCallback {

        CreditConsumeResult doConsume(CreditConsumeParams consumeParams);

    }

    interface NotifyCallback {

        void onSuccess(String orderNum);

        void onFailure(String orderNum, String errorMessage);

    }
}
