package cn.tuia.explore.center.api.dto.general;

import cn.tuia.explore.center.api.enums.LikeType;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: LikeMessage.java , v 0.1 2019-05-29 09:31 ElinZhou Exp $
 */
public class LikeMessage extends AbstractMessageContent {
    private static final long serialVersionUID = 7848168658819107139L;

    private int type;

    private long msgId;

    private int count;

    private long userId;

    private String nickName;


    @Override
    protected String title() {
        String title;
        if (LikeType.of(type) == LikeType.POST) {
            title = String.format("%s等%d个用户赞了你的动态", nickName, count);
        } else {
            title = String.format("%s等%d个用户赞了你的评论", nickName, count);
        }
        return title;
    }

    @Override
    protected String content() {
        return null;
    }

    @Override
    protected String icon() {
        return null;
    }


    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getMsgId() {
        return msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }
}
