package cn.tuia.explore.center.api.dto.general;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ReplyCommentMessage.java , v 0.1 2019-05-29 09:32 ElinZhou Exp $
 */
public class ReplyCommentMessage extends AbstractMessageContent {
    private static final transient long serialVersionUID = -6234722035726038714L;

    private static final transient String TEMPLATE = "%s 回复了你的评论";

    private long replyUserId;

    private long commentId;

    private transient String nickName;

    private transient String headImage;

    private transient String content;

    @Override
    public String title() {
        return String.format(TEMPLATE, nickName);
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public String icon() {
        return headImage;
    }

    public long getReplyUserId() {
        return replyUserId;
    }

    public void setReplyUserId(long replyUserId) {
        this.replyUserId = replyUserId;
    }

    public long getCommentId() {
        return commentId;
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
