package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户行为类型
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: UserOperationType.java , v 0.1 2019-05-28 10:47 ElinZhou Exp $
 */
public enum UserOperationType {
    /**
     * |-------------------------------------------------------------------------------------
     * |编码   |行为    |主动方  |被动方  |主动方行为id     |被动方行为id
     * |------------------------------------------------------------------------------------------
     * |1     |发帖    |发帖人  |无     |postId         |无
     * |------------------------------------------------------------------------------------------
     * |2     |回复评论 |回复人  |原作者  |commentId      |commentId
     * |------------------------------------------------------------------------------------------
     * |3     |回复帖子 |回复人  |原作者  |commentId      |postId
     * |------------------------------------------------------------------------------------------
     * |4     |点赞评论 |点赞人  |原作者  |无             |commentId
     * |------------------------------------------------------------------------------------------
     * |5     |点赞帖子 |点赞人  |原作者  |无             |postId
     * |------------------------------------------------------------------------------------------
     * |6     |分享帖子 |分享人  |原作者  |无             |无
     * |------------------------------------------------------------------------------------------
     * |7     |访问主页 |访问人  |主人    |无             |无
     * |------------------------------------------------------------------------------------------
     * |8     |关注用户 |关注人  |被关注人 |无             |无
     * |-------------------------------------------------------------------------------------------
     */


    /**
     * 发布帖子
     */
    PUBLISH_POST(1, true, false, true, false),
    /**
     * 回复评论
     */
    REPLY_TO_COMMENT(2, true, true, true, true),
    /**
     * 回复帖子
     */
    REPLY_TO_POST(3, true, true, true, true),
    /**
     * 点赞评论
     */
    LIKE_COMMENT(4, true, true, false, true),
    /**
     * 点赞帖子
     */
    LIKE_POST(5, true, true, false, true),
    /**
     * 分享帖子
     */
    SHARE_POST(6, true, true, false, false),
    /**
     * 访问主页
     */
    VISIT_HOME_PAGE(7, true, true, false, false),
    /**
     * 关注用户
     */
    FOLLOW_USER(8, true, true, false, false),


    ;
    private static final Map<Integer, UserOperationType> CACHE =
            Arrays.stream(UserOperationType.values()).collect(Collectors.toMap(UserOperationType::getCode, p -> p));


    private int code;

    private boolean activeUser;
    private boolean passiveUser;
    private boolean activeId;
    private boolean passiveId;


    public static UserOperationType of(int code) {
        return CACHE.get(code);
    }

    UserOperationType(int code, boolean activeUser, boolean passiveUser, boolean activeId, boolean passiveId) {
        this.code = code;
        this.activeUser = activeUser;
        this.passiveUser = passiveUser;
        this.activeId = activeId;
        this.passiveId = passiveId;
    }

    public int getCode() {
        return code;
    }

    public boolean isActiveUser() {
        return activeUser;
    }

    public boolean isPassiveUser() {
        return passiveUser;
    }

    public boolean isActiveId() {
        return activeId;
    }

    public boolean isPassiveId() {
        return passiveId;
    }}
