package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.UserFollowPageReqDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteUserFollowService.java , v 0.1 2019-05-24 14:13 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserFollowService {

    /**
     * 分页查询关注列表
     *
     * @param reqDto
     * @return
     */
    PageQueryResultDto<Long> pageQuery(UserFollowPageReqDto reqDto);


    /**
     * 关注某人
     *
     * @param userId
     * @param followUsers
     * @return
     */
    boolean follow(Long userId, List<Long> followUsers);

    /**
     * 取消关注
     *
     * @param userId
     * @param followUsers
     * @return
     */
    boolean unfollow(Long userId, List<Long>  followUsers);


}
