package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.rsp.VisitDto;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteVisitService.java , v 0.1 2019-05-28 14:28 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteVisitService {

    /**
     * 访问主页
     *
     * @param vistorUserId 访客userid
     * @param masterUserId 主人userid
     */
    void visit(long vistorUserId, long masterUserId) throws BizException;

    /**
     * 分页查询来访记录
     *
     * @param userId
     * @return
     */
    List<VisitDto> pageQuery(long userId);

}
