package cn.tuia.explore.center.api.dto.general;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ReplyPostMessage.java , v 0.1 2019-05-29 09:32 ElinZhou Exp $
 */
public class ReplyPostMessage extends AbstractMessageContent {
    private static final long serialVersionUID = 3712072417707823637L;

    private static final transient String TEMPLATE = "%s 回复了你的动态";

    private long replyUserId;

    private long commentId;

    private transient String nickName;

    private transient String headImage;

    private transient String content;

    public ReplyPostMessage() {
    }

    public ReplyPostMessage(long replyUserId, long commentId) {
        this.replyUserId = replyUserId;
        this.commentId = commentId;
    }

    @Override
    protected Long userId() {
        return replyUserId;
    }

    @Override
    public String title() {
        return String.format(TEMPLATE, nickName);
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public String icon() {
        return headImage;
    }

    public long getReplyUserId() {
        return replyUserId;
    }

    public void setReplyUserId(long replyUserId) {
        this.replyUserId = replyUserId;
    }

    public long getCommentId() {
        return commentId;
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
