package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostSourceType.java , v 0.1 2019-05-23 17:05 ElinZhou Exp $
 */
public enum PostSourceType {

    /**
     * 未知
     */
    UNKNOW("未知", 999),

    /**
     * 原创
     */
    ORIGINAL("原创", 0),

    /**
     * 公众号
     */
    GONGZHONGHAO("公众号", 1),

    /**
     * 快手
     */
    KUAISHOU("快手", 2),

    /**
     * 抖音
     */
    DOUYIN("抖音", 3),

    /**
     * 皮皮虾
     */
    PIPIXIA("皮皮虾", 4),

    /**
     * 美篇
     */
    MEIPIAN("美篇", 5),

    ;


    private static final Map<Integer, PostSourceType> CACHE =
            Arrays.stream(PostSourceType.values()).collect(Collectors.toMap(PostSourceType::getCode, p -> p));

    PostSourceType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    private String name;

    private int code;

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static PostSourceType of(int code) {
        return CACHE.get(code);
    }

}
