/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostChannel {
    HOT("\u793e\u4f1a", 1),
    HEALTH("\u5065\u5eb7", 2),
    EMOTION("\u60c5\u611f", 3),
    FUNNY("\u641e\u7b11", 4);

    private static final Map<Integer, PostChannel> CACHE;
    private String title;
    private int code;

    private PostChannel(String title, int code) {
        this.title = title;
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public int getCode() {
        return this.code;
    }

    public static PostChannel of(Integer code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));
    }
}

