/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum UserLikeTag {
    CULTURE("\u6587\u5316", 1, true),
    HEALTH("\u517b\u751f", 2, true),
    HISTORY("\u5386\u53f2", 3, true),
    FUNNY("\u641e\u7b11", 4, true),
    SOCIETY("\u793e\u4f1a", 5, true),
    EMOTION("\u60c5\u611f", 6, true),
    TOURISM("\u65c5\u884c", 7, true),
    LIFE("\u751f\u6d3b", 8, true),
    SPORTS("\u4f53\u80b2", 9, true),
    ENTERTAINMENT("\u5a31\u4e50", 10, true),
    TECHNOLOGY("\u79d1\u6280", 11, true),
    CAR("\u6c7d\u8f66", 12, true),
    MILITARY("\u519b\u4e8b", 13, true),
    FOOD("\u7f8e\u98df", 14, true),
    EDUCATION("\u6559\u80b2", 15, true),
    MUSIC("\u97f3\u4e50", 16, false),
    FASHION("\u65f6\u5c1a", 17, false),
    GAME("\u6e38\u620f", 18, false),
    ANIME("\u52a8\u6f2b", 19, false),
    FORTUNE("\u8fd0\u52bf", 20, false),
    PET("\u5ba0\u7269", 21, false),
    SQUARE_DANCE("\u5e7f\u573a\u821e", 22, false),
    PHOTOGRAPHY("\u6444\u5f71", 23, false),
    PARENT_CHILD("\u4eb2\u5b50", 24, false),
    FINANCE("\u8d22\u7ecf", 25, false);

    private static final Map<Integer, UserLikeTag> CACHE;
    private String desc;
    private int code;
    private boolean show;

    private UserLikeTag(String desc, int code, boolean show) {
        this.desc = desc;
        this.code = code;
        this.show = show;
    }

    public static List<UserLikeTag> showList() {
        return Arrays.stream(UserLikeTag.values()).filter(UserLikeTag::isShow).sorted(Comparator.comparingInt(UserLikeTag::getCode)).collect(Collectors.toList());
    }

    public static UserLikeTag of(int code) {
        return CACHE.get(code);
    }

    public String getDesc() {
        return this.desc;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isShow() {
        return this.show;
    }

    static {
        CACHE = Arrays.stream(UserLikeTag.values()).collect(Collectors.toMap(UserLikeTag::getCode, u -> u));
    }
}

