/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.dto.general.AbstractMessageContent;
import cn.tuia.explore.center.api.dto.general.AttentionMessage;
import cn.tuia.explore.center.api.dto.general.LikeMessage;
import cn.tuia.explore.center.api.dto.general.ReplyCommentMessage;
import cn.tuia.explore.center.api.dto.general.ReplyPostMessage;
import cn.tuia.explore.center.api.dto.general.SystemMessage;
import cn.tuia.explore.center.api.enums.MessageType;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MessageStoreType {
    LIKE(1, MessageType.LIKE, LikeMessage.class),
    REPLY_COMMENT(2, MessageType.REPLY_COMMENT, ReplyCommentMessage.class),
    REPLY_POST(3, MessageType.REPLY_POST, ReplyPostMessage.class),
    ATTENTION(4, MessageType.ATTENTION, AttentionMessage.class),
    SYSTEM(5, MessageType.SYSTEM, SystemMessage.class);

    private int code;
    private MessageType type;
    private Class<? extends AbstractMessageContent> clazz;
    private static final Map<Integer, MessageStoreType> CACHE;

    public static MessageStoreType of(int code) {
        return CACHE.get(code);
    }

    private MessageStoreType(int code, MessageType type, Class<? extends AbstractMessageContent> clazz) {
        this.code = code;
        this.type = type;
        this.clazz = clazz;
    }

    public int getCode() {
        return this.code;
    }

    public MessageType getType() {
        return this.type;
    }

    public Class<? extends AbstractMessageContent> getClazz() {
        return this.clazz;
    }

    static {
        CACHE = Arrays.stream(MessageStoreType.values()).collect(Collectors.toMap(MessageStoreType::getCode, p -> p));
    }
}

