/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.UserAchievementType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum Achievement {
    ZERO(1, 0L, 0L, 0L),
    ONE(2, 1L, 1L, 1L),
    TWO(3, 10L, 5L, 5L),
    THREE(4, 30L, 15L, 15L),
    FOUR(5, 60L, 30L, 30L),
    FIVE(6, 100L, 50L, 50L),
    SIX(7, 150L, 75L, 75L),
    SEVEN(8, 200L, 100L, 100L),
    EIGHT(9, 300L, 150L, 150L),
    NINE(10, 400L, 200L, 200L),
    TEN(11, 500L, 250L, 250L),
    ELEVEN(12, 700L, 350L, 350L),
    TWELVE(13, 900L, 450L, 450L),
    THIRTEEN(14, 1200L, 600L, 600L),
    FOURTEEN(15, 1500L, 750L, 750L),
    FIFTEEN(16, 1800L, 900L, 900L),
    INFINITE(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private int level;
    private long read;
    private long comment;
    private long share;
    private static final List<Achievement> LIST;
    private static final Map<Integer, Achievement> CACHE;

    private Achievement(int level, long read, long comment, long share) {
        this.level = level;
        this.read = read;
        this.comment = comment;
        this.share = share;
    }

    public int getLevel() {
        return this.level;
    }

    public long getRead() {
        return this.read;
    }

    public long getComment() {
        return this.comment;
    }

    public long getShare() {
        return this.share;
    }

    public static Achievement of(int level) {
        Achievement achievement = CACHE.get(level);
        if (achievement != null) {
            return achievement;
        }
        return ZERO;
    }

    public static Achievement level(UserAchievementType type, long process) {
        if (type == UserAchievementType.READ) {
            process /= 60L;
        }
        for (Achievement achievement : LIST) {
            if (process >= Achievement.getGoal(type, achievement)) continue;
            return Achievement.of(achievement.getLevel() - 1);
        }
        return ZERO;
    }

    private static long getGoal(UserAchievementType type, Achievement achievement) {
        if (type == UserAchievementType.READ) {
            return achievement.getRead();
        }
        if (type == UserAchievementType.COMMENT) {
            return achievement.getComment();
        }
        if (type == UserAchievementType.SHARE) {
            return achievement.getShare();
        }
        return 0L;
    }

    static {
        LIST = Arrays.stream(Achievement.values()).sorted(Comparator.comparingInt(Achievement::getLevel)).collect(Collectors.toList());
        CACHE = LIST.stream().collect(Collectors.toMap(Achievement::getLevel, a -> a));
    }
}

