/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum NewsCollectionType {
    MORNING_PAPER(1, 6, 12, "\u540c\u770b\u65e9\u62a5\uff0c\u6c47\u805a\u5929\u4e0b\u5927\u4e8b"),
    AFTERNOON(2, 12, 18, "\u540c\u770b\u4e0b\u5348\u8336\uff0c\u4f34\u4f60\u5348\u540e\u5c0f\u61a9"),
    EVENING_PAPAER(3, 18, 24, "\u540c\u770b\u665a\u62a5\uff0c\u56de\u987e\u4e00\u5929\u70ed\u70b9");

    private int code;
    private int startIncludeHour;
    private int endExcludeHour;
    private String title;
    private static final Map<Integer, NewsCollectionType> CACHE;

    private NewsCollectionType(int code, int startIncludeHour, int endExcludeHour, String title) {
        this.code = code;
        this.startIncludeHour = startIncludeHour;
        this.endExcludeHour = endExcludeHour;
        this.title = title;
    }

    public int getCode() {
        return this.code;
    }

    public int getStartIncludeHour() {
        return this.startIncludeHour;
    }

    public String getTitle() {
        return this.title;
    }

    public int getEndExcludeHour() {
        return this.endExcludeHour;
    }

    public static NewsCollectionType of(Integer code) {
        return CACHE.get(code);
    }

    public static NewsCollectionType now() {
        int hour = LocalDateTime.now().getHour();
        Optional<NewsCollectionType> optional = Arrays.stream(NewsCollectionType.values()).filter(t -> t.startIncludeHour <= hour && t.endExcludeHour > hour).findFirst();
        return optional.orElse(null);
    }

    static {
        CACHE = Arrays.stream(NewsCollectionType.values()).collect(Collectors.toMap(NewsCollectionType::getCode, n -> n));
    }
}

