/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.PostGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostChannel {
    POST_HOT("\u793e\u4f1a", 1, 1, PostGroup.ARTICLE, true),
    POST_HEALTH("\u5065\u5eb7", 2, 2, PostGroup.ARTICLE, true),
    POST_EMOTION("\u60c5\u611f", 3, 3, PostGroup.ARTICLE, true),
    POST_FUNNY("\u641e\u7b11", 4, 4, PostGroup.ARTICLE, true),
    POST_TECHNOLOGY("\u79d1\u6280", 35, 5, PostGroup.ARTICLE, true),
    POST_CAR("\u6c7d\u8f66", 23, 6, PostGroup.ARTICLE, true),
    POST_HISTORY("\u5386\u53f2", 24, 7, PostGroup.ARTICLE, true),
    POST_FASHION("\u65f6\u5c1a", 25, 8, PostGroup.ARTICLE, true),
    POST_ENTERTAINMENT("\u5a31\u4e50", 26, 9, PostGroup.ARTICLE, true),
    POST_SPORT("\u4f53\u80b2", 27, 10, PostGroup.ARTICLE, true),
    POST_EDUCATION("\u6559\u80b2", 28, 11, PostGroup.ARTICLE, true),
    POST_FINANCE("\u8d22\u7ecf", 30, 13, PostGroup.ARTICLE, true),
    POST_TOURISM("\u65c5\u6e38", 31, 14, PostGroup.ARTICLE, true),
    POST_FOOD("\u7f8e\u98df", 32, 15, PostGroup.ARTICLE, false),
    POST_NEWS("\u8981\u95fb", 33, 16, PostGroup.ARTICLE, false),
    POST_EXPLORE("\u63a2\u7d22", 34, 17, PostGroup.ARTICLE, false),
    VIDEO_FUNNY("\u641e\u7b11", 5, 1, PostGroup.VIDEO, true),
    VIDEO_MOVIE("\u5f71\u89c6", 6, 2, PostGroup.VIDEO, true),
    VIDEO_VARIETY("\u7efc\u827a", 7, 3, PostGroup.VIDEO, true),
    VIDEO_FOOD("\u7f8e\u98df", 8, 4, PostGroup.VIDEO, true),
    VIDEO_SQUARE_DANCE("\u5e7f\u573a\u821e", 9, 5, PostGroup.VIDEO, true),
    VIDEO_NBA("NBA", 11, 6, PostGroup.VIDEO, true),
    VIDEO_PET("\u5ba0\u7269", 12, 7, PostGroup.VIDEO, true),
    VIDEO_SPORT("\u4f53\u80b2", 13, 8, PostGroup.VIDEO, true),
    VIDEO_ENTERTAINMENT("\u5a31\u4e50", 14, 9, PostGroup.VIDEO, true),
    VIDEO_CULTURE("\u6587\u5316", 15, 10, PostGroup.VIDEO, true),
    VIDEO_MUSIC("\u97f3\u4e50", 16, 11, PostGroup.VIDEO, true),
    VIDEO_FASHION("\u65f6\u5c1a", 17, 12, PostGroup.VIDEO, true),
    VIDEO_MANUAL("\u624b\u5de5", 18, 13, PostGroup.VIDEO, true),
    VIDEO_TECHNOLOGY("\u79d1\u6280", 19, 14, PostGroup.VIDEO, true),
    VIDEO_PARENT_CHILD("\u4eb2\u5b50", 20, 15, PostGroup.VIDEO, true),
    VIDEO_VLOG("VLOG", 21, 16, PostGroup.VIDEO, true),
    VIDEO_FARMER("\u519c\u4eba", 22, 17, PostGroup.VIDEO, true);

    private static final Map<Integer, PostChannel> CACHE;
    private String title;
    private int code;
    private int sort;
    private PostGroup group;
    private boolean show;

    private PostChannel(String title, int code, int sort, PostGroup group, boolean show) {
        this.title = title;
        this.code = code;
        this.sort = sort;
        this.group = group;
        this.show = show;
    }

    public String getTitle() {
        return this.title;
    }

    public int getCode() {
        return this.code;
    }

    public PostGroup getGroup() {
        return this.group;
    }

    public boolean isShow() {
        return this.show;
    }

    public int getSort() {
        return this.sort;
    }

    public static PostChannel of(Integer code) {
        return CACHE.get(code);
    }

    public static List<PostChannel> getChannels(PostGroup group) {
        return Arrays.stream(PostChannel.values()).filter(p -> p.getGroup() == group).filter(PostChannel::isShow).sorted(Comparator.comparingInt(PostChannel::getSort)).collect(Collectors.toList());
    }

    static {
        CACHE = Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));
    }
}

