package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 金币收入
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: CoinExpense.java , v 0.1 2019-09-10 17:06 ElinZhou Exp $
 */
public enum CoinIncome implements CoinTradeCode {

    UNKNOW(0, "未知收入"),

    WITHDRAW_REFUND(1, "提现驳回"),

    ;

    CoinIncome(int bizCode, String desc) {
        this.bizCode = bizCode;
        this.desc = desc;
    }

    private int bizCode;

    private String desc;

    private static final Map<Integer, CoinIncome> CACHE =
            Arrays.stream(CoinIncome.values()).collect(Collectors.toMap(CoinIncome::bizCode, c -> c));

    public static CoinIncome of(int bizCode) {
        CoinIncome coinIncome = CACHE.get(bizCode);
        if (coinIncome != null) {
            return coinIncome;
        }
        return UNKNOW;
    }


    @Override
    public int bizCode() {
        return bizCode;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
