package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: ReadTaskType.java , v 0.1 2019-09-18 17:10 ElinZhou Exp $
 */
public enum ReadTaskType {

    NEWBIE(1, "新手班", 1, 5),
    PRIMARY(2, "初级班", 3, 15),
    MIDDLE(3, "中级班", 7, 15),
    SENIRO(4, "高级班", 21, 15),

    ;

    ReadTaskType(int level, String name, int durationDays, int minutes) {
        this.level = level;
        this.name = name;
        this.durationDays = durationDays;
        this.minutes = minutes;
    }

    private int level;

    private String name;

    private int durationDays;

    private int minutes;

    private static final Map<Integer, ReadTaskType> CACHE =
            Arrays.stream(ReadTaskType.values()).collect(Collectors.toMap(ReadTaskType::getLevel, r -> r));

    public static ReadTaskType of(int level) {
        return CACHE.get(level);
    }

    public int getLevel() {
        return level;
    }

    public String getName() {
        return name;
    }

    public int getDurationDays() {
        return durationDays;
    }

    public int getMinutes() {
        return minutes;
    }}
