package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: UserLikeTag.java , v 0.1 2019-06-18 11:45 ElinZhou Exp $
 */
public enum UserLikeTag {
    CULTURE("文化", 1, true),
    HEALTH("养生", 2, true),
    HISTORY("历史", 3, true),
    FUNNY("搞笑", 4, true),
    SOCIETY("社会", 5, true),
    EMOTION("情感", 6, true),
    TOURISM("旅行", 7, true),
    LIFE("生活", 8, true),
    SPORTS("体育", 9, true),
    ENTERTAINMENT("娱乐", 10, true),
    TECHNOLOGY("科技", 11, true),
    CAR("汽车", 12, true),
    MILITARY("军事", 13, true),
    FOOD("美食", 14, true),
    EDUCATION("教育", 15, true),

    MUSIC("音乐", 16, false),
    FASHION("时尚", 17, false),
    GAME("游戏", 18, false),
    ANIME("动漫", 19, false),
    FORTUNE("运势", 20, false),
    PET("宠物", 21, false),
    SQUARE_DANCE("广场舞", 22, false),
    PHOTOGRAPHY("摄影", 23, false),
    PARENT_CHILD("亲子", 24, false),
    FINANCE("财经", 25, false),
    AGRICULTURE("农业", 26, false),
    MANUAL("手工", 27, false),



    ;

    private static final Map<Integer, UserLikeTag> CACHE =
            Arrays.stream(UserLikeTag.values()).collect(Collectors.toMap(UserLikeTag::getCode, u -> u));

    private String desc;

    private int code;

    private boolean show;

    UserLikeTag(String desc, int code, boolean show) {
        this.desc = desc;
        this.code = code;
        this.show = show;

    }

    public static List<UserLikeTag> showList() {
        return Arrays.stream(UserLikeTag.values()).filter(UserLikeTag::isShow).sorted(Comparator.comparingInt
                (UserLikeTag::getCode)).collect(Collectors.toList());
    }

    public static UserLikeTag of(int code) {
        return CACHE.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }

    public boolean isShow() {
        return show;
    }

}
