package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: VerifyScene.java , v 0.1 2019-06-12 15:52 ElinZhou Exp $
 */
public enum VerifyScene {


    /**
     * 手机短信绑定
     */
    PHONE_SMS_BINDING(1, VerifyType.SMS, 10, TimeUnit.MINUTES, 55, TimeUnit.SECONDS),

    /**
     * 手机号登录
     */
    PHONE_LOGIN(2, VerifyType.SMS, 10, TimeUnit.MINUTES, 55, TimeUnit.SECONDS),

    ;

    private int code;

    private VerifyType type;

    private long expireTime;

    private TimeUnit expireUnit;

    private long refreshTime;

    private TimeUnit refreshUnit;

    private static final Map<Integer, VerifyScene> CACHE =
            Arrays.stream(VerifyScene.values()).collect(Collectors.toMap(VerifyScene::getCode, v -> v));

    public static VerifyScene of(int code) {
        return CACHE.get(code);
    }

    VerifyScene(int code, VerifyType type, long expireTime, TimeUnit expireUnit, long refreshTime,
                TimeUnit refreshUnit) {
        this.code = code;
        this.type = type;
        this.expireTime = expireTime;
        this.expireUnit = expireUnit;
        this.refreshTime = refreshTime;
        this.refreshUnit = refreshUnit;
    }

    public int getCode() {
        return code;
    }

    public VerifyType getType() {
        return type;
    }

    public long getExpireTime() {
        return expireTime;
    }

    public TimeUnit getExpireUnit() {
        return expireUnit;
    }

    public long getRefreshTime() {
        return refreshTime;
    }

    public TimeUnit getRefreshUnit() {
        return refreshUnit;
    }}
