package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: WithdrawStatus.java , v 0.1 2019-09-11 15:25 ElinZhou Exp $
 */
public enum WithdrawStatus {


    REVIEWING(1, "审核中", false),
    REJECT(3, "拒绝", false),
    REFUND(4, "驳回", false),
    SUCCESS_WATI_PAY(5, "成功待打款", false),
    SUCCESS_WAIT_RETRY(6, "成功待重试", false),
    PAID(7, "已打款", true),
    ;

    WithdrawStatus(int code, String desc, boolean finaly) {
        this.code = code;
        this.desc = desc;
        this.finaly = finaly;
    }

    private int code;

    private String desc;

    private boolean finaly;

    private static final Map<Integer, WithdrawStatus> CACHE =
            Arrays.stream(WithdrawStatus.values()).collect(Collectors.toMap(WithdrawStatus::getCode, w -> w));

    public static WithdrawStatus of(int code) {
        return CACHE.get(code);
    }


    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isFinaly() {
        return finaly;
    }}
