package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.LikeDto;
import cn.tuia.explore.center.api.dto.req.LikeReqDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteLikeService.java , v 0.1 2019-05-24 10:07 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteLikeService {

    /**
     * 对某条消息点赞或取消点赞
     *
     * @param reqDto
     * @throws BizException
     */
    void like(LikeReqDto reqDto) throws BizException;

    /**
     * 判断某条信息用户是否已经点赞
     *
     * @param likeDto
     * @return
     */
    boolean isLike(LikeDto likeDto);


    /**
     * 查询最近点赞情况
     *
     * @param userId
     * @param msgIds
     * @param likeType
     * @return
     * @see cn.tuia.explore.center.api.enums.LikeType
     */
    Map<Long, Boolean> queryRecentlyLikeStatus(long userId, List<Long> msgIds, Integer likeType);


    /**
     * 查询点赞情况
     * 由于点赞记录进行了分表，本方法性能很差，尽量使用queryRecentlyLikeStatus查询
     *
     * @param userId
     * @param msgIds
     * @param likeType
     * @return
     * @see cn.tuia.explore.center.api.enums.LikeType
     */
    Map<Long, Boolean> queryLikeStatus(long userId, List<Long> msgIds, Integer likeType);

}