package cn.tuia.explore.center.api.dto.rsp;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: WithdrawRecordDto.java , v 0.1 2019-09-16 15:03 ElinZhou Exp $
 */
public class WithdrawRecordDto implements Serializable {

    private static final long serialVersionUID = -7077555314685168413L;
    /**
     * 申请时间
     */
    private Date time;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 提现金额 单位：分
     */
    private Long fee;

    /**
     * 金币数量
     */
    private Long coins;

    /**
     * 提现账号
     */
    private String account;

    /**
     * 当前状态
     *
     * @see cn.tuia.explore.center.api.enums.WithdrawStatus
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 提现渠道：1.支付宝 2：微信
     */
    private Integer channel;

    /**
     * 提现流水号
     */
    private String serialNumber;

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Long getCoins() {
        return coins;
    }

    public void setCoins(Long coins) {
        this.coins = coins;
    }
}
