package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: DailyMissionType.java , v 0.1 2019-10-08 15:17 ElinZhou Exp $
 */
public enum DailyMissionType {


    COMMENT(1, "发表3条评论", "评论字数须超过12字", 50L, 150L, 3L,
            "https://yun.dui88.com/quwen/picture/fbec2505-7d55-467d-89ac-c9f6b513d35a.png"),
    WATCH_VIDEO(2, "看5个视频", "视频观看时间超过30秒", 50L, 150L, 5L,
            "https://yun.dui88.com/quwen/picture/63710d2a-7906-4744-ab8d-0aec8a40a285.png"),
    SHARE_POST(3, "分享3篇文章", "分享到微信群内有效", 50L, 150L, 3L,
            "https://yun.dui88.com/quwen/picture/023ab0e0-9ed2-452f-9aa0-ab9928891acf.png"),

    ;
    //
    private int id;
    //任务名称
    private String title;
    //任务描述
    private String desc;
    //任务奖励随机起始值
    private Long startInclude;
    //任务奖励随机结束值
    private Long endExclude;
    //任务目标
    private Long target;
    //图片地址
    private String imageUrl;

    private static final Map<Integer, DailyMissionType> CACHE =
            Arrays.stream(DailyMissionType.values()).collect(Collectors.toMap(DailyMissionType::getId, d -> d));

    DailyMissionType(int id, String title, String desc, Long startInclude, Long endExclude, Long target,
                     String imageUrl) {
        this.id = id;
        this.title = title;
        this.desc = desc;
        this.startInclude = startInclude;
        this.endExclude = endExclude;
        this.target = target;
        this.imageUrl = imageUrl;
    }

    public static DailyMissionType of(int id) {
        return CACHE.get(id);
    }


    public String getImageUrl() {
        return imageUrl;
    }

    public int getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public String getDesc() {
        return desc;
    }

    public Long getStartInclude() {
        return startInclude;
    }

    public Long getEndExclude() {
        return endExclude;
    }

    public Long getTarget() {
        return target;
    }}
