package cn.tuia.explore.center.api.enums;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: NewsCollectionType.java , v 0.1 2019-07-15 19:53 ElinZhou Exp $
 */
public enum NewsCollectionType {

    /**
     * 早报
     */
    MORNING_PAPER(1, 6, 12, "同看早报，汇聚天下大事"),

    /**
     * 下午茶
     */
    AFTERNOON(2, 12, 18, "同看下午茶，伴你午后小憩"),

    /**
     * 晚报
     */
    EVENING_PAPAER(3, 18, 24, "同看晚报，回顾一天热点"),


    ;


    private int code;

    private int startIncludeHour;

    private int endExcludeHour;

    private String title;

    private static final Map<Integer, NewsCollectionType> CACHE =
            Arrays.stream(NewsCollectionType.values()).collect(Collectors.toMap(NewsCollectionType::getCode, n -> n));


    NewsCollectionType(int code, int startIncludeHour, int endExcludeHour, String title) {
        this.code = code;
        this.startIncludeHour = startIncludeHour;
        this.endExcludeHour = endExcludeHour;
        this.title = title;
    }

    public int getCode() {
        return code;
    }

    public int getStartIncludeHour() {
        return startIncludeHour;
    }

    public String getTitle() {
        return title;
    }

    public int getEndExcludeHour() {
        return endExcludeHour;
    }

    public static NewsCollectionType of(Integer code) {
        return CACHE.get(code);
    }

    public static NewsCollectionType now() {
        int hour = LocalDateTime.now().getHour();
        Optional<NewsCollectionType> optional =
                Arrays.stream(NewsCollectionType.values()).filter(t -> t.startIncludeHour <= hour && t.endExcludeHour > hour).findFirst();
        return optional.orElse(null);
    }
}
