package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostChannel.java , v 0.1 2019-07-14 15:40 ElinZhou Exp $
 */
public enum PostChannel {

    POST_HOT("社会", 1, 1, PostGroup.ARTICLE, true),
    POST_HEALTH("健康", 2, 2, PostGroup.ARTICLE, true),
    POST_EMOTION("情感", 3, 3, PostGroup.ARTICLE, true),
    POST_FUNNY("搞笑", 4, 4, PostGroup.ARTICLE, true),
    POST_TECHNOLOGY("科技", 35, 5, PostGroup.ARTICLE, true),

    POST_CAR("汽车", 23, 6, PostGroup.ARTICLE, true),
    POST_HISTORY("历史", 24, 7, PostGroup.ARTICLE, true),
    POST_FASHION("时尚", 25, 8, PostGroup.ARTICLE, true),
    POST_ENTERTAINMENT("娱乐", 26, 9, PostGroup.ARTICLE, true),
    POST_SPORT("体育", 27, 10, PostGroup.ARTICLE, true),
    POST_EDUCATION("教育", 28, 11, PostGroup.ARTICLE, true),
//    POST_MILITARY("军事", 29, 12, PostGroup.ARTICLE, true),
    POST_FINANCE("财经", 30, 13, PostGroup.ARTICLE, true),
    POST_TOURISM("旅游", 31, 14, PostGroup.ARTICLE, true),

    POST_FOOD("美食", 32, 15, PostGroup.ARTICLE, false),
    POST_NEWS("要闻", 33, 16, PostGroup.ARTICLE, false),
    POST_EXPLORE("探索", 34, 17, PostGroup.ARTICLE, false),


    VIDEO_FUNNY("搞笑", 5, 1, PostGroup.VIDEO, true),
    VIDEO_MOVIE("影视", 6, 2, PostGroup.VIDEO, true),
    VIDEO_VARIETY("综艺", 7, 3, PostGroup.VIDEO, true),
    VIDEO_FOOD("美食", 8, 4, PostGroup.VIDEO, true),
    VIDEO_SQUARE_DANCE("广场舞", 9, 5, PostGroup.VIDEO, true),
    VIDEO_NBA("NBA", 11, 6, PostGroup.VIDEO, true),
    VIDEO_PET("宠物", 12, 7, PostGroup.VIDEO, true),
    VIDEO_SPORT("体育", 13, 8, PostGroup.VIDEO, true),
    VIDEO_ENTERTAINMENT("娱乐", 14, 9, PostGroup.VIDEO, true),
    VIDEO_CULTURE("文化", 15, 10, PostGroup.VIDEO, true),
    VIDEO_MUSIC("音乐", 16, 11, PostGroup.VIDEO, true),
    VIDEO_FASHION("时尚", 17, 12, PostGroup.VIDEO, true),
    VIDEO_MANUAL("手工", 18, 13, PostGroup.VIDEO, true),
    VIDEO_TECHNOLOGY("科技", 19, 14, PostGroup.VIDEO, true),
    VIDEO_PARENT_CHILD("亲子", 20, 15, PostGroup.VIDEO, true),
    VIDEO_VLOG("VLOG", 21, 16, PostGroup.VIDEO, true),
    VIDEO_FARMER("农人", 22, 17, PostGroup.VIDEO, true),
    ;


    private static final Map<Integer, PostChannel> CACHE =
            Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));

    PostChannel(String title, int code, int sort, PostGroup group, boolean show) {
        this.title = title;
        this.code = code;
        this.sort = sort;
        this.group = group;
        this.show = show;
    }

    private String title;
    private int code;
    private int sort;

    private PostGroup group;

    private boolean show;

    public String getTitle() {
        return title;
    }

    public int getCode() {
        return code;
    }

    public PostGroup getGroup() {
        return group;
    }

    public boolean isShow() {
        return show;
    }

    public int getSort() {
        return sort;
    }

    public static PostChannel of(Integer code) {
        return CACHE.get(code);
    }

    public static List<PostChannel> getChannels(PostGroup group) {
        return Arrays.stream(PostChannel.values()).filter(p -> p.getGroup() == group).filter(PostChannel::isShow).sorted(Comparator.comparingInt(PostChannel::getSort)).collect(Collectors.toList());
    }


}
