package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.AppWeakUserBaseReqDto;
import cn.tuia.explore.center.api.dto.req.BaseQueryDto;
import cn.tuia.explore.center.api.dto.req.DiscussQueryDto;
import cn.tuia.explore.center.api.dto.req.VoteReqDto;
import cn.tuia.explore.center.api.dto.rsp.DiscussDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteDiscussService.java , v 0.1 2019-07-23 16:59 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteDiscussService {
    /**
     * 创建一个话题
     *
     * @param newDto
     */
    void createDiscuss(DiscussDto newDto) throws BizException;

    /**
     * 投票
     *
     * @param voteReqDto
     * @throws BizException
     */
    void vote(VoteReqDto voteReqDto) throws BizException;

    /**
     * 查询某个话题
     *
     * @param req
     * @return
     * @throws BizException
     */
    DiscussDto queryById(DiscussQueryDto req) throws BizException;

    /**
     * 获取最新的没有曝光过的话题
     *
     * @return
     */
    DiscussDto queryLastOne(AppWeakUserBaseReqDto dto);

    PageQueryResultDto<DiscussDto> pageQuery(BaseQueryDto dto);

    boolean update(DiscussDto discussDto) throws BizException;

}
