package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.CommentDetailReq;
import cn.tuia.explore.center.api.dto.req.UserFollowPageReqDto;
import cn.tuia.explore.center.api.dto.rsp.CommentDetailDto;
import cn.tuia.explore.center.api.dto.rsp.LikeMessageDto;
import cn.tuia.explore.center.api.dto.rsp.MessagePageDto;
import com.google.common.annotations.Beta;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteMessageService.java , v 0.1 2019/5/28 9:37 PM ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteMessageService {

    /**
     * 查询所有消息
     *
     * @param pageReqDto
     * @return
     */
    MessagePageDto query(UserFollowPageReqDto pageReqDto) throws BizException;

    /**
     * 查询点赞详情
     *
     * @param userId
     * @return
     */
    List<LikeMessageDto> likeMessageDetail(long userId, int currentPage, int pageSize);

    /**
     * 将某条消息置为已读
     *
     * @param ids
     * @return
     */
    boolean read(List<Long> ids);

    /**
     * 将所有消息置为已读
     *
     * @param userId
     * @return
     */
    boolean readAll(long userId);

    /**
     * 已读来访
     *
     * @param userId
     * @return
     */
    boolean readVisitor(long userId);


    /**
     * 查询消息中心的一条评论或点赞的详情页
     * 返回结果是一条顶级评论下跟着若干符合条件的子评论
     *
     * @param detailReq
     * @return
     */
    CommentDetailDto commentDetail(CommentDetailReq detailReq) throws BizException;


    /**
     * 是否有未读消息
     *
     * @param userId
     * @return
     */
    @Beta
    boolean remind(long userId) throws BizException;

}
