/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import cn.tuia.explore.center.entity.ChineseDay;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ChineseCalendar {
    private static volatile ChineseCalendar chineseCalendar;
    private Map<LocalDate, ChineseDay> mapper = new HashMap<LocalDate, ChineseDay>();

    private ChineseCalendar(String data) {
        Splitter splitter = Splitter.on((String)".").trimResults().omitEmptyStrings();
        Joiner joiner = Joiner.on((String)" ");
        JSONArray jsonArray = JSON.parseArray((String)data);
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            for (Map.Entry entry : jsonObject.entrySet()) {
                LocalDate date = LocalDate.parse((CharSequence)entry.getKey(), DateTimeFormatter.ISO_DATE);
                ChineseDay chineseDay = (ChineseDay)((JSONObject)entry.getValue()).toJavaObject(ChineseDay.class);
                if (StringUtils.isNotEmpty((CharSequence)chineseDay.getAvoid())) {
                    chineseDay.setAvoid(joiner.join((Iterable)splitter.splitToList((CharSequence)chineseDay.getAvoid()).stream().limit(2L).collect(Collectors.toList())));
                }
                if (StringUtils.isNotEmpty((CharSequence)chineseDay.getSuit())) {
                    chineseDay.setSuit(joiner.join((Iterable)splitter.splitToList((CharSequence)chineseDay.getSuit()).stream().limit(2L).collect(Collectors.toList())));
                }
                this.mapper.put(date, chineseDay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChineseCalendar newInstance(String data) {
        if (chineseCalendar != null) return chineseCalendar;
        Class<ChineseCalendar> clazz = ChineseCalendar.class;
        synchronized (ChineseCalendar.class) {
            if (chineseCalendar != null) return chineseCalendar;
            chineseCalendar = new ChineseCalendar(data);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return chineseCalendar;
        }
    }

    public ChineseDay get(LocalDate date) {
        return this.mapper.get(date);
    }
}

