/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateUtil {
    private DateUtil() {
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String timeDesc(Date time) {
        long duration = Duration.between(DateUtil.toLocalDateTime(time), LocalDateTime.now()).getSeconds();
        if (duration < 60L) {
            return "\u521a\u521a";
        }
        if (duration < 3600L) {
            return String.format("%s\u5206\u949f\u524d", duration / 60L);
        }
        if (duration < 86400L) {
            return String.format("%s\u5c0f\u65f6\u524d", duration / 60L / 60L);
        }
        if (duration < 2678400L) {
            return String.format("%s\u5929\u524d", duration / 60L / 60L / 24L);
        }
        if (duration < 31536000L) {
            return String.format("%s\u4e2a\u6708\u524d", duration / 60L / 60L / 24L / 31L);
        }
        return "\u5f88\u4e45\u524d";
    }
}

