/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class DeflateUtil {
    private static final String TAG_CODE = "DEFLATEDATA-";

    private DeflateUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isDeflateData(String data) {
        return data.startsWith(TAG_CODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompress(String data) throws IOException {
        if (StringUtils.isBlank((CharSequence)data)) {
            return "";
        }
        if (!DeflateUtil.isDeflateData(data)) {
            return data;
        }
        data = data.substring(TAG_CODE.length());
        byte[] inputByte = Base64.decodeBase64((String)data);
        int len = 0;
        Inflater infl = new Inflater();
        infl.setInput(inputByte);
        byte[] outByte = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while (!infl.finished() && (len = infl.inflate(outByte)) != 0) {
                bos.write(outByte, 0, len);
            }
            infl.end();
        }
        return bos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(String data) throws IOException {
        byte[] inputByte = data.getBytes();
        Deflater defl = new Deflater();
        defl.setLevel(4);
        defl.setInput(inputByte);
        defl.finish();
        byte[] outputByte = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while (!defl.finished()) {
                int len = defl.deflate(outputByte);
                bos.write(outputByte, 0, len);
            }
            defl.end();
        }
        return TAG_CODE + Base64.encodeBase64String((byte[])bos.toByteArray());
    }
}

