/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class GzipUtil {
    private static final String TAG_CODE = "GZIPDATA-";

    private GzipUtil() {
        throw new UnsupportedOperationException();
    }

    public static String zip(String data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data.getBytes());
        gzip.close();
        return TAG_CODE + out.toString(StandardCharsets.ISO_8859_1.name());
    }

    public static String unzip(String data) throws IOException {
        int n;
        if (StringUtils.isBlank((CharSequence)data)) {
            return "";
        }
        if (!GzipUtil.isGzipData(data)) {
            return data;
        }
        data = data.substring(TAG_CODE.length());
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes(StandardCharsets.ISO_8859_1));
        GZIPInputStream gzipInputStream = new GZIPInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        while ((n = gzipInputStream.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString();
    }

    public static boolean isGzipData(String data) {
        return data.startsWith(TAG_CODE);
    }
}

