/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class VersionUtil {
    public static final String FIRST_CODE = "0.0.0.0.0";
    public static final String LAST_CODE = "255.255.255.255.255";
    public static final long FIRST_NUMBER = 0L;
    public static final long LAST_NUMBER = 0xFFFFFFFFFFL;

    private VersionUtil() {
        throw new UnsupportedOperationException("\u4e0d\u53ef\u5b9e\u4f8b\u5316\u7684\u7c7b");
    }

    public static Long toVersionNumber(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        AtomicInteger bit = new AtomicInteger(32);
        return Splitter.on((String)".").omitEmptyStrings().trimResults().splitToList((CharSequence)code).stream().mapToLong(Long::parseLong).reduce(0L, (a, b) -> a | b << bit.getAndAdd(-8));
    }

    public static String toVersionCode(Long num) {
        if (num == null) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Joiner.on((String)".").join((Iterable)Stream.iterate(40, bit -> bit - 8).limit(5L).map(bit -> ((long)Math.pow(2.0, bit.intValue()) - 1L & num) >> bit - 8).map(String::valueOf).collect(Collectors.toList()));
    }

    public static int compare(String version1, String version2) {
        if (VersionUtil.toVersionNumber(version1) > VersionUtil.toVersionNumber(version2)) {
            return 1;
        }
        if (VersionUtil.toVersionNumber(version1) < VersionUtil.toVersionNumber(version2)) {
            return -1;
        }
        return 0;
    }

    public static Boolean between(String version, String smaller, String bigger) {
        return VersionUtil.compare(version, smaller) >= 0 && VersionUtil.compare(version, bigger) < 0;
    }
}

