/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import cn.tuia.explore.center.entity.RecommendRecord;
import cn.tuia.explore.center.util.BaseInnerRuleDto;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseInnerLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInnerLog.class);
    private static final String EXPLORE_INNER_LOG_GROUP = "12";
    private static final String POST_RECOMMEND_LOG = "5";
    private static final String DATE_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public static void postRecommendLog(RecommendRecord recommendRecord) {
        BaseInnerLog.log(JSON.toJSONString((Object)recommendRecord), POST_RECOMMEND_LOG, EXPLORE_INNER_LOG_GROUP);
    }

    private static void log(String json, String type, String group) {
        if (StringUtils.isNotEmpty((String)json)) {
            BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
            ruleDto.setGroup(group);
            ruleDto.setJson(json.replace("\\n", ""));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATTER);
            ruleDto.setTime(simpleDateFormat.format(new Date()));
            ruleDto.setType(type);
            String jsonString = JSON.toJSONString((Object)ruleDto);
            LOGGER.info("{}", (Object)jsonString);
        }
    }

    private BaseInnerLog() {
    }
}

