/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryUtil.class);

    private RetryUtil() {
    }

    public static boolean retry(BooleanSupplier supplier, int times) {
        return RetryUtil.retry(supplier, times, TimeUnit.MILLISECONDS, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean retry(BooleanSupplier supplier, int times, TimeUnit timeUnit, int unit) {
        try {
            DBTimeProfile.enter((String)"retry");
            int total = times;
            boolean success = false;
            while (times > 0) {
                try {
                    success = supplier.getAsBoolean();
                }
                catch (Exception e) {
                    LOGGER.error("\u4e1a\u52a1\u51fa\u9519\uff0c\u8fdb\u884c\u7b2c{}\u6b21\u91cd\u8bd5", (Object)(total - times + 1), (Object)e);
                }
                if (success) break;
                --times;
                try {
                    timeUnit.sleep(unit);
                }
                catch (InterruptedException e) {
                    LOGGER.error("\u4e1a\u52a1\u91cd\u8bd5\u4e2d\u88ab\u4e2d\u65ad", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = success;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

