/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import cn.tuia.explore.center.constant.GlobalConstant;
import cn.tuia.explore.center.entity.PureContent;
import cn.tuia.explore.center.enums.PushType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gexin.rp.sdk.base.IBatch;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.TagMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.notify.Notify;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.dto.GtReq;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTuiPush {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeTuiPush.class);
    private static final int MAX_RETRY_TIMES = 3;
    private static final String GETUI_RESULT = "result";
    private static final String GETUI_RESULT_CODE_CID = "ok";
    private static final List<String> GETUI_SETTAG_RESULT = Arrays.asList("Success", "TagNoChange");
    private static final Integer MAX_TAG_COUNT = 100;
    private IGtPush push;
    private String appId;
    private String appKey;
    private String packageName;
    private String component;

    public GeTuiPush(IGtPush push, String appId, String appKey, String packageName, String component) {
        this.push = push;
        this.appId = appId;
        this.appKey = appKey;
        this.packageName = packageName;
        this.component = component;
    }

    public void setTag(String clientId, Set<Long> adds, Set<Long> deletes) {
        Set addTags = adds == null ? Collections.emptySet() : adds.stream().map(String::valueOf).collect(Collectors.toSet());
        Set deleteTags = deletes == null ? Collections.emptySet() : deletes.stream().map(String::valueOf).collect(Collectors.toSet());
        IPushResult iPushResult = this.push.getUserTags(this.appId, clientId);
        if (null == iPushResult || null == iPushResult.getResponse() || null == iPushResult.getResponse().get("tags")) {
            return;
        }
        String tagStrings = iPushResult.getResponse().get("tags").toString();
        List currentTagIds = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)tagStrings);
        List tags = new ArrayList(currentTagIds);
        tags.addAll(addTags);
        tags = tags.stream().filter(t -> !deleteTags.contains(t)).limit(MAX_TAG_COUNT.intValue()).collect(Collectors.toList());
        IQueryResult iQueryResult = this.push.setClientTag(this.appId, clientId, tags);
        if ((null == iQueryResult || !GETUI_SETTAG_RESULT.contains(iQueryResult.getResponse().get(GETUI_RESULT).toString())) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("\u8bf7\u6c42\u4e2a\u63a8setClientTag\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)iQueryResult));
        }
    }

    public void pushToTag(PureContent pureContent, long tagId) {
        TransmissionTemplate transmissionTemplate = this.buildTemplate(pureContent);
        TagMessage message = new TagMessage();
        message.setAppIdList(Collections.singletonList(this.appId));
        message.setTag(String.valueOf(tagId));
        message.setData((ITemplate)transmissionTemplate);
        message.setOffline(true);
        message.setOfflineExpireTime(TimeUnit.DAYS.toMillis(1L));
        IPushResult iPushResult = this.push.pushTagMessage(message);
        this.handleResult(iPushResult);
    }

    public void pushToUser(PureContent pureContent, Collection<String> clientIds) {
        TransmissionTemplate template = this.buildTemplate(pureContent);
        String taskId = this.getTaskId(template);
        IPushResult iPushResult = this.push.pushMessageToList(taskId, this.targetList(clientIds));
        this.handleResult(iPushResult);
    }

    public List<PureContent> batchPush(List<PureContent> pureContents) {
        ArrayList<PureContent> failContent = new ArrayList<PureContent>();
        IBatch batch = this.push.getBatch();
        for (PureContent pureContent : pureContents) {
            if (pureContent.retry() >= 3) continue;
            TransmissionTemplate template = this.buildTemplate(pureContent);
            SingleMessage message = new SingleMessage();
            message.setData((ITemplate)template);
            message.setOffline(true);
            message.setOfflineExpireTime(TimeUnit.DAYS.toMillis(1L));
            Target target = new Target();
            target.setAppId(this.appId);
            target.setClientId(pureContent.getClientId());
            try {
                batch.add(message, target);
            }
            catch (Exception e) {
                failContent.add(pureContent);
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("\u6dfb\u52a0\u6279\u91cf\u63a8\u9001\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)pureContent), (Object)e);
            }
        }
        return this.handlerResult(pureContents, failContent, batch);
    }

    public void pushToAll(PureContent pureContent) {
        TransmissionTemplate template = this.buildTemplate(pureContent);
        AppMessage message = new AppMessage();
        message.setData((ITemplate)template);
        message.setOffline(true);
        message.setOfflineExpireTime(TimeUnit.DAYS.toMillis(1L));
        AppConditions cdt = new AppConditions();
        message.setAppIdList(Collections.singletonList(this.appId));
        message.setConditions(cdt);
        IPushResult iPushResult = this.push.pushMessageToApp(message, "");
        this.handleResult(iPushResult);
    }

    private void handleResult(IPushResult iPushResult) {
        String result;
        if (null != iPushResult && !GETUI_RESULT_CODE_CID.equals(result = iPushResult.getResponse().get(GETUI_RESULT).toString()) && !"Success".equals(result)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("\u8bf7\u6c42\u4e2a\u63a8pushMessageToList\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)iPushResult));
            }
            throw new IllegalStateException("\u8bf7\u6c42\u4e2a\u63a8\u63a5\u53e3\u5931\u8d25,\u539f\u56e0\u6839\u636e\u65e5\u5fd7\u67e5\u8be2");
        }
    }

    private String getTaskId(TransmissionTemplate template) {
        ListMessage message = new ListMessage();
        message.setData((ITemplate)template);
        message.setOffline(true);
        message.setOfflineExpireTime(TimeUnit.DAYS.toMillis(1L));
        return this.push.getContentId(message);
    }

    private List<Target> targetList(Collection<String> clients) {
        return clients.stream().distinct().map(cid -> {
            Target target = new Target();
            target.setAppId(this.appId);
            target.setClientId(cid);
            return target;
        }).collect(Collectors.toList());
    }

    private TransmissionTemplate buildTemplate(PureContent pureContent) {
        String title = pureContent.getTitle();
        String content = pureContent.getDesc();
        String path = pureContent.getAndroidJump();
        Map<String, String> extra = pureContent.getExtra();
        if (extra == null) {
            extra = new HashMap<String, String>(1);
        }
        extra.put("androidJump", path);
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        PushType pushType = PushType.of(pureContent.getType());
        if (pushType != PushType.THROUGH_DATA) {
            Notify notify = new Notify();
            notify.setTitle(title);
            notify.setContent(content);
            notify.setType(GtReq.NotifyInfo.Type._intent);
            StringBuilder intent = new StringBuilder(String.format("intent:#Intent;action=android.intent.action.oppopush;package=%s;component=%s;", this.packageName, this.component));
            try {
                String urlPath = "S.path=" + URLEncoder.encode(path, GlobalConstant.DEFAULT_ENCODING) + ";";
                String params = "S.params=" + URLEncoder.encode(JSON.toJSONString(extra), GlobalConstant.DEFAULT_ENCODING) + ";";
                String urlTitle = "S.title=" + URLEncoder.encode(title, GlobalConstant.DEFAULT_ENCODING) + ";";
                String urlContent = "S.content=" + URLEncoder.encode(content, GlobalConstant.DEFAULT_ENCODING) + ";";
                intent.append(urlPath).append(params).append(urlTitle).append(urlContent).append("end");
                notify.setIntent(intent.toString());
                template.set3rdNotifyInfo(notify);
            }
            catch (Exception e) {
                LOGGER.warn("intent\u4e3a\uff1a{}", (Object)intent, (Object)e);
            }
        }
        template.setTransmissionType(2);
        extra.put("pushType", pushType.getCode());
        extra.put("title", title);
        extra.put("content", content);
        template.setTransmissionContent(JSON.toJSONString(extra));
        return template;
    }

    private List<PureContent> handlerResult(List<PureContent> pureContents, List<PureContent> failContent, IBatch batch) {
        try {
            IPushResult result = batch.submit();
            Object object = result.getResponse().get("info");
            if (object != null) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(result.getResponse().get("info")));
                for (Map.Entry entry : jsonObject.entrySet()) {
                    JSONObject item;
                    String index = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof JSONObject) || GETUI_RESULT_CODE_CID.equals((item = (JSONObject)value).getString(GETUI_RESULT))) continue;
                    LOGGER.error("\u63a8\u9001\u5931\u8d25\uff0ccid:{},\u5931\u8d25\u539f\u56e0:{}", (Object)item.getString("cid"), (Object)item.getString(GETUI_RESULT));
                    failContent.add(pureContents.get(Integer.parseInt(index) - 1));
                }
            }
            return failContent;
        }
        catch (IOException e) {
            LOGGER.error("\u63a8\u9001\u5931\u8d25", (Throwable)e);
            return pureContents;
        }
    }
}

