/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.util;

import cn.tuia.explore.center.constant.GlobalConstant;
import cn.tuia.explore.center.enums.RedisKey;
import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

public class RedisKeyUtil {
    private static final String SEPARATOR = "_";
    private static final String EC_PREFIX = "EC";

    public static String dailyLuckyGenLock() {
        return RedisKeyUtil.getKey(RedisKey.K47, new Object[0]);
    }

    public static String dailyMission(long userId, int missionId) {
        return RedisKeyUtil.getKey(RedisKey.K45, userId, missionId, LocalDate.now());
    }

    public static String withdrawLimit(long userId) {
        return RedisKeyUtil.getKey(RedisKey.K44, userId, LocalDate.now());
    }

    public static String joinReadTaskLock(long userId) {
        return RedisKeyUtil.getKey(RedisKey.K43, userId);
    }

    public static String isCreateReadTask() {
        return RedisKeyUtil.getKey(RedisKey.K40, LocalDate.now());
    }

    public static String startWatch(long userId, long postId) {
        return RedisKeyUtil.getKey(RedisKey.K39, userId, postId);
    }

    public static String recommendMessageRecord(long userId) {
        return RedisKeyUtil.getKey(RedisKey.K38, userId, LocalDate.now());
    }

    public static String readRecord(String uuid, long userId, int type) {
        return RedisKeyUtil.getKey(RedisKey.K37, uuid, userId, type);
    }

    public static String lastClickTag(long userId, int tag) {
        return RedisKeyUtil.getKey(RedisKey.K33, userId, tag);
    }

    public static String unreadRedmin(long userId) {
        return RedisKeyUtil.getKey(RedisKey.K32, userId);
    }

    public static String tokenExchange(String token) {
        return RedisKeyUtil.getKey(RedisKey.K01, token);
    }

    public static String pushLockKey() {
        return RedisKeyUtil.getKey(RedisKey.K02, new Object[0]);
    }

    public static String pushListKey(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K03, time.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String likeTimes(long msgId, int msgType) {
        return RedisKeyUtil.getKey(RedisKey.K04, msgId, msgType);
    }

    public static String commentTimes(long msgId, int msgType) {
        return RedisKeyUtil.getKey(RedisKey.K05, msgId, msgType);
    }

    public static String shareTimes(long postId) {
        return RedisKeyUtil.getKey(RedisKey.K06, postId);
    }

    public static String waitSyncLike(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K07, time.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String waitSyncComment(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K08, time.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String waitSyncShare(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K09, time.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String timerKey(Class<?> clazz, String key) {
        return RedisKeyUtil.getKey(RedisKey.K10, clazz.getSimpleName(), key);
    }

    public static String counterWaitSync(Class<?> clazz, LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K11, clazz.getSimpleName(), time.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String visitLock(long vistorUserId, long masterUserId) {
        return RedisKeyUtil.getKey(RedisKey.K12, vistorUserId, masterUserId);
    }

    public static String subCommentList(long commentId) {
        return RedisKeyUtil.getKey(RedisKey.K13, commentId);
    }

    public static String waitSyncSubComment(LocalDateTime localDateTime) {
        return RedisKeyUtil.getKey(RedisKey.K14, localDateTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
    }

    public static String userFollowRcmd(Date date) {
        return RedisKeyUtil.getKey(RedisKey.K15, new SimpleDateFormat("yyyyMMdd").format(date));
    }

    public static String smsVerify(String phoneNum) {
        return RedisKeyUtil.getKey(RedisKey.K17, phoneNum);
    }

    public static String recordLockKey(String userKey) {
        return RedisKeyUtil.getKey(RedisKey.K19, userKey);
    }

    public static String postScore(long postId) {
        return RedisKeyUtil.getKey(RedisKey.K20, postId);
    }

    public static String postExposure(String deviceId, long postId) {
        return RedisKeyUtil.getKey(RedisKey.K21, deviceId, postId);
    }

    public static String postEnter(String deviceId, long postId) {
        return RedisKeyUtil.getKey(RedisKey.K22, deviceId, postId);
    }

    public static String postExit(String deviceId, long postId) {
        return RedisKeyUtil.getKey(RedisKey.K23, deviceId, postId);
    }

    public static String postPoolCache(int size, int currentPage, int type) {
        return RedisKeyUtil.getKey(RedisKey.K24, size, currentPage, type);
    }

    public static String postScoreClearKey(String deviceId, long postId) {
        return RedisKeyUtil.getKey(RedisKey.K25, deviceId, postId);
    }

    public static String waitPushList(LocalDateTime localDateTime) {
        return RedisKeyUtil.getKey(RedisKey.K26, localDateTime.format(GlobalConstant.DEFAULT_DATE_TIME_FOMATTER));
    }

    public static String exposureKey(String id, String date) {
        return RedisKeyUtil.getKey(RedisKey.K27, id, date);
    }

    public static String clickKey(String id, String date) {
        return RedisKeyUtil.getKey(RedisKey.K28, id, date);
    }

    public static String postChannelCache(int size, int currentPage, int type) {
        return RedisKeyUtil.getKey(RedisKey.K30, size, currentPage, type);
    }

    private static String getKey(RedisKey redisKey, Object ... objects) {
        return RedisKeyUtil.getKey(EC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object ... objects) {
        Joiner joiner = Joiner.on((String)SEPARATOR).skipNulls();
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(prefix);
        items.add((Object)redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);
    }

    private RedisKeyUtil() {
    }
}

