package cn.tuia.payment.api.dto.rsp;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhiheng
 */
@Data
@NoArgsConstructor
public class ResultPage<T> implements Serializable {
    private static final long serialVersionUID = -6995927968639099048L;
    /**
     * 当前页面
     */
    private Long currentPage;
    /**
     * 总页数
     */
    private Long totalPage;
    /**
     * 分页查询count总数.
     */
    private Long totalCount;
    /**
     * 分页查询结果集.
     */
    private List<T> list;

    public ResultPage(Long totalCount, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
    }

    public ResultPage(Long currentPage, Long totalPage, Long totalCount, List<T> list) {
        this.currentPage = currentPage;
        this.totalPage = totalPage;
        this.totalCount = totalCount;
        this.list = list;
    }
}
