package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.github.jeffreyning.mybatisplus.anno.MppMultiId;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_pay_order")
public class PayOrderEntity implements Serializable {
    private static final long serialVersionUID = 2273796998561255122L;
    /**
     * 推啊订单id
     */
    @TableField("tuia_id")
    @MppMultiId
    private String tuiaId;

    /**
     * 我们的订单号
     */
    @TableField("order_id")
    @MppMultiId
    private String orderId;

    /**
     * 来源场景，正常1，返回拦截2，挽留3
     */
    @TableField("source_scene")
    private Integer sourceScene;

    /**
     * 支付渠道，目前就一个易宝
     */
    @TableField("payment_channel")
    private Integer paymentChannel;

    /**
     * 发起方商户编号
     */
    @TableField("parent_merchant_no")
    private String parentMerchantNo;

    /**
     * 商户号
     */
    @TableField("merchant_no")
    private String merchantNo;

    /**
     * 二级商户号（现在就联动有）
     */
    @TableField("bank_merchant_no")
    private String bankMerchantNo;

    /**
     * 支付方式,WECHAT,ALIPAY
     */
    @TableField("pay_way")
    private String payWay;

    /**
     * 支付链接
     */
    @TableField("pay_url")
    private String payUrl;

    /**
     * 行业
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 支付订单号（外部的订单号）
     */
    @TableField("pay_order_no")
    private String payOrderNo;

    /**
     * 支付宝流水线号（待确定）
     */
    @TableField("bank_order_id")
    private String bankOrderId;

    /**
     * 支付时间
     */
    @TableField("pay_time")
    private Date payTime;

    /**
     * advert_key
     */
    @TableField("advert_key")
    private String advertKey;
    /**
     * store_id
     */
    @TableField("store_id")
    private String storeId;

    /**
     * 支付金额
     */
    @TableField("pay_amount")
    private Long payAmount;

    /**
     * 原始金额（未降价前）
     */
    @TableField("original_amount")
    private Long originalAmount;

    /**
     * 支付状态
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 退款状态
     */
    @TableField("refund_status")
    private Integer refundStatus;

    /**
     * 积木id
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * 商品名称
     */
    @TableField("goods_name")
    private String goodsName;

    /**
     * ip
     */
    @TableField("ip")
    private String ip;
    /**
     * app_id
     */
    @TableField("app_id")
    private String appId;
    /**
     * app_path
     */
    @TableField("app_path")
    private String appPath;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;
}
