package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 子商户号投放状态
 * 在投、待投、下线、未知
 * 投放状态的依赖于联动状态和推啊状态
 * 下线：以下任一种场景，直接置为下线
 * 联动状态=【禁用】或【关闭】
 * 推啊状态=【禁用】或【关闭】
 *
 * @author lizhiheng
 * @see BankMerStatusEnums
 */

@Getter
@AllArgsConstructor
public enum BankMerReleasingStatusEnums {

    RELEASING(1, "在投"),
    WAITING_2_RELEASE(2, "待投"),
    BANNED(3, "下线"),
    OTHER(-1, "未知或者其他"),
    ;

    private final Integer code;
    private final String msg;
}
