/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class TimePeriodUtil {
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static int getPeriod() {
        int hour = LocalTime.now().getHour();
        int period = hour < 7 ? 1 : (hour < 13 ? 2 : (hour < 19 ? 3 : 4));
        return period;
    }

    public static int getNextPeriod() {
        int period = TimePeriodUtil.getPeriod();
        period = period == 4 ? 1 : ++period;
        return period;
    }

    public static String getNextPeriodDate() {
        int period = TimePeriodUtil.getPeriod();
        String format = period == 4 ? LocalDate.now().plusDays(1L).format(YYYY_MM_DD) : LocalDate.now().format(YYYY_MM_DD);
        return format;
    }

    public static String getPeriodDate() {
        return LocalDate.now().format(YYYY_MM_DD);
    }
}

