/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import java.util.Objects;

public enum ActOrderStatusEnum {
    INITIAL(0, "\u521d\u59cb\u503c"),
    UN_PAY(10, "\u5f85\u652f\u4ed8"),
    PAYING(11, "\u652f\u4ed8\u4e2d"),
    PAID(20, "\u5df2\u652f\u4ed8"),
    CASHING(21, "\u63d0\u73b0\u4e2d"),
    UN_PAID(22, "\u672a\u652f\u4ed8"),
    PAYED_TO_TRANS(23, "\u652f\u4ed8\u4e86\uff0c\u4f46\u662f\u6709\u8f6c\u8d26\u4fe1\u606f"),
    PAYED_TO_REFUND(24, "\u652f\u4ed8\u4e86\uff0c\u4f46\u662f\u6709\u9000\u6b3e\u4fe1\u606f"),
    CASH_FAILED(29, "\u63d0\u73b0\u5931\u8d25"),
    CASHED(30, "\u5df2\u63d0\u73b0"),
    REFUND_ING(32, "\u9000\u6b3e\u4e2d"),
    REFUND_FAIL(35, "\u9000\u6b3e\u5931\u8d25"),
    REFUNDED(40, "\u5df2\u9000\u6b3e");

    private final Integer code;
    private final String msg;

    public static Integer convertVOStatus(Integer code) {
        if (code >= REFUND_ING.getCode()) {
            return code;
        }
        if (code >= CASHED.getCode()) {
            return CASHED.getCode();
        }
        if (code >= PAID.getCode()) {
            return PAID.getCode();
        }
        if (code >= UN_PAY.getCode()) {
            return UN_PAY.getCode();
        }
        return code;
    }

    public static boolean isFinished(Integer status) {
        return !Objects.isNull(status) && (status.equals(CASHED.getCode()) || status.equals(REFUNDED.getCode()));
    }

    public static boolean isUnPay(Integer status) {
        return !Objects.isNull(status) && status < PAID.getCode();
    }

    public static boolean isTrans(Integer status) {
        return !Objects.isNull(status) && status >= CASHED.getCode();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    private ActOrderStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}

