package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum RefundStatusEnum {
    REFUND_IN_DB_WX(58, "", "微信小程序退款入库了"),
    REFUND_IN_DB(59, "", "退款入库了"),
    REFUND_SUCCESS(60, "REFUND_SUCCESS", "退费成功"),
    REFUND_FAIL(70, "REFUND_FAIL", "您的订单退款失败，请稍后再试或联系客服进行退款"),
    REFUND_WILL_BE_PROCESS_TILL_1230(79, "", "您的退款订单已提交，请关注账户余额"),
    REFUND_PROCESS(80, "REFUND_PROCESSING", "退费处理中"),//	商户发起退费请求后，平台受理成功，则会返回此状态。
    REFUND_UNKNOWN(90, "", "退费结果不明"),//	当退费由于网络等诸多因素造成超时时，会返回此状态。
    REFUND_WAIT_AUDIT(100, "", "等待人工审核"),// 企业版人工操作退款,查询退款状态时会返回。
    MER_PROCESS(110, "", "您的订单退款失败，请联系人工客服进行退款"),//	查询返回此字段需调用退款信息补录接口进行退款信息补录。
    ;


    private final Integer code;
    private final String fubeiCode;
    private final String msg;

    /**
     * ！！这个方法只能给联动用，因为联动的枚举值是根据枚举的name()来的
     */
    public static Integer liandongTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.name().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return REFUND_PROCESS.getCode();
    }

    /**
     * ！！这个方法只能给付呗用，因为付呗的枚举值是根据fubeiCode来的
     */
    public static Integer fubeiTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getFubeiCode().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return REFUND_PROCESS.getCode();
    }
}
