package cn.tuia.payment.api.constants;

/**
 * @author lizhiheng
 */
public class RedisKey {
    /**
     * 例子：55502_BANK_MER_PERIOD_1_POOL
     * 55502商户在第1时间段内的子商户池
     * 尽量使用下面这个方法，formatPoolKey，参数不容易传错位置
     */
    private static final String BANK_MER_PERIOD_POOL = "%s_BANK_MER_PERIOD_%s_POOL";

    public static String formatPoolKey(String merId, int period) {
        return String.format(BANK_MER_PERIOD_POOL, merId, period);
    }
}
