package cn.tuia.payment.api.enums;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: OnOffEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.20 15:00
 */
@Getter
@AllArgsConstructor
public enum OnOffEnum {

    OFF(0, "关闭"),

    ON(1, "开启"),

    ;


    private final Integer code;
    private final String msg;

    public static Integer getCode(String msg) {
        for (OnOffEnum value : OnOffEnum.values()) {
            if (Objects.equal(value.getMsg(), msg)) {
                return value.getCode();
            }
        }
        return null;
    }

    public static String getMsg(Integer code) {
        for (OnOffEnum value : OnOffEnum.values()) {
            if (Objects.equal(value.getCode(), code)) {
                return value.getMsg();
            }
        }
        return null;
    }

    public static boolean isValid(String msg) {
        for (OnOffEnum value : OnOffEnum.values()) {
            if (Objects.equal(value.getMsg(), msg)) {
                return true;
            }
        }
        return false;
    }
}
