package cn.tuia.payment.api.constants;


import lombok.Data;

/**
 * @author lizhiheng
 */
@Data
public class SomeConstants {
    public static final String LD_RELEASING_NUM_CONFIG = "%s_ld_releasing_num_config";
    public static final String LD_RELEASING_NUM_CONFIG_V2 = "%s_ld_releasing_num_config_v2";
    public static final String LD_REMAINING_NUM_CONFIG = "%s_ld_remaining_num_config";
    public static final String LD_PULL_UP_RATE_CONFIG = "%s_ld_pull_up_rate_config";
    public static final String LD_RELEASING_UPDATE_CONFIG = "ld_releasing_update_config";

    public static final String UP_RELEASING_NUM_CONFIG = "%s_up_releasing_num_config";
    public static final String UP_RELEASING_NUM_CONFIG_V2 = "%s_up_releasing_num_config_v2";
    public static final String UP_REMAINING_NUM_CONFIG = "%s_up_remaining_num_config";
    public static final String UP_PULL_UP_RATE_CONFIG = "%s_up_pull_up_rate_config";
    public static final String UP_RELEASING_UPDATE_CONFIG = "up_releasing_update_config";

    public static String getLdReleasingNumConfig(String merId) {
        return String.format(LD_RELEASING_NUM_CONFIG, merId);
    }


    public static String getLdReleasingNumConfigV2(String merId) {
        return String.format(LD_RELEASING_NUM_CONFIG_V2, merId);
    }

    public static String getLdPullUpRateConfig(String merId) {
        return String.format(LD_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getLdRemainingNumConfig(String merId) {
        return String.format(LD_REMAINING_NUM_CONFIG, merId);
    }

    public static String getUpReleasingNumConfig(String merId) {
        return String.format(UP_RELEASING_NUM_CONFIG, merId);
    }

    public static String getUpReleasingNumConfigV2(String merId) {
        return String.format(UP_RELEASING_NUM_CONFIG_V2, merId);
    }

    public static String getUpPullUpRateConfig(String merId) {
        return String.format(UP_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getUpRemainingNumConfig(String merId) {
        return String.format(UP_REMAINING_NUM_CONFIG, merId);
    }

//    public static String getRemainingNumConfig(String merId) {
//        return String.format(REMAINING_NUM_CONFIG, merId);
//    }
}