package cn.tuia.payment.api.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * @author lizhiheng
 */
public class TimePeriodUtil {
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyyMMdd");

    /**
     * 获取当前时间段
     */
    public static int getPeriod() {
        // 8.22 短支付-子商户时段逻辑优化
        // 需要改成全天投放而不是时段投放，1为投放，0为不投放
        // https://duiba.yuque.com/vw1kkl/xldgmf/me7p4axxq50fv47g
        if (true) {
            return 1;
        }
        int hour = LocalTime.now().getHour();
        int period;
        if (hour < 6) {
            period = 1;
        } else if (hour < 12) {
            period = 2;
        } else if (hour < 18) {
            period = 3;
        } else {
            period = 4;
        }
        return period;
    }

    /**
     * 获取下一个时间段
     */
    public static int getNextPeriod() {
        int period = getPeriod();
        if (period == 4) {
            period = 1;
        } else {
            period = period + 1;
        }
        return period;
    }

    public static String getNextPeriodDate() {
        int period = getPeriod();
        String format;
        if (period == 4) {
            format = LocalDate.now().plusDays(1).format(YYYY_MM_DD);
        } else {
            format = LocalDate.now().format(YYYY_MM_DD);
        }
        return format;
    }

    public static String getPeriodDate() {
        return LocalDate.now().format(YYYY_MM_DD);
    }
}
