package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer_daily_data")
public class BankMerDailyDataEntity implements Serializable {

    private static final long serialVersionUID = -6409926368583322147L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 数据日期
     */
    @TableField("date")
    private String date;

    /**
     * 这里的mer_id，联动里代表商家编号，银联代表行业，复用一下
     */
    @TableField("mer_id")
    private String merId;

    /**
     * 支付渠道
     */
    @TableField("payment_channel")
    private Integer paymentChannel;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 告警状态
     */
    @TableField("warning_status")
    private Integer warningStatus;

    /**
     * 预支付次数（唤起支付次数）
     */
    @TableField("prepay_times")
    private Integer prepayTimes;

    /**
     * 支付成功次数
     */
    @TableField("pay_success_times")
    private Integer paySuccessTimes;
}