package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplainChannelEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:39
 */
@Getter
@AllArgsConstructor
public enum ComplainChannelEnum {

    UNION_PAY(1, "银联"),
    ;

    private final Integer code;
    private final String msg;

    public static String getMsg(Integer code) {
        for (ComplainChannelEnum value : ComplainChannelEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getMsg();
            }
        }
        return null;
    }
}
