package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.BankMerDTO;
import cn.tuia.payment.api.dto.BankMerPoolDTO;
import cn.tuia.payment.api.dto.req.*;
import cn.tuia.payment.api.dto.req.up.UpBankMerQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;

/**
 * @author y.zhao
 * @title: RemoteBankMerPoolService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.02 11:38
 */
@AdvancedFeignClient
public interface RemoteBankMerPoolService {

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<BankMerPoolDTO> page(ReqPageQuery<BankMerPoolQuery> query);

    /**
     * 创建/更新
     *
     * @param req
     * @return
     */
    BankMerPoolDTO upsert(BankMerPoolCreateReq req);

    /**
     * 商户池 批量关联 商户号
     *
     * @param req
     * @return
     */
    Boolean relationBankMerId(BankMerRelationReq req);

    /**
     * 商户池 批量关联 商户号
     * 根据查询条件批量关联
     * 联动
     *
     * @param query
     * @return
     */
    Boolean relationBankMerId4BankQuery(BankMerRelationQuery query);


    /**
     * 商户池 批量关联 商户号
     * 根据查询条件批量关联
     * 银联
     *
     * @param query
     * @return
     */
    Boolean relationBankMerId4UpBankQuery(UpBankMerRelationQuery query);

}
